import argparse
import json
import logging
import logging.config
from cse_image_items.Image import ImageFactory

logger = logging.getLogger(__name__)


def logger_configuration():
    try:
        with open("logger_configuration.json", 'r') as logging_configuration_file:
            config_dict = json.load(logging_configuration_file)
    except IOError:
        print('logger_configuration file does exist')
    logging.config.dictConfig(config_dict)


def parse_args():
    """ Arguments parsing

    Returns:
        argparse.Namespace -- the arguments
     """
    logger.info('START parse_args FUNCTION')

    parser = argparse.ArgumentParser(description='The image information')
    parser.add_argument('--image', '-img', required=True, help="The image path")
    parser.add_argument('--layout', '-l', required=True,
                        help="The layout of the image (1.7)")
    parser.add_argument('--CSERegionOnly', '-cse', required=False,
                        action='store_true', help="in case of CSE region only")
    try:
        args = parser.parse_args()
        logger.debug('user\'s command is: [%s]' %(args))
        return args
    except SystemExit as exc:
        exit(1)


def main():
    logger_configuration()
    logger.info('the LAYOUT PARSING has been STARTED...')
    args = parse_args()
    image = ImageFactory.create(args.image, args.layout, args.CSERegionOnly)
    logger.info('the layout parsing COMPLETED')


if __name__ == '__main__':
    try:
        main()
    except Exception as exc:
        exit(1)
